/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import io.github.apace100.origins.access.EndRespawningEntity;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.PreventSleepPower;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Unit;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayerEntity.class})
public abstract class ServerPlayerEntityMixin
extends PlayerEntity
implements IContainerListener,
EndRespawningEntity {
    @Shadow
    private RegistryKey<World> field_241137_cq_;
    @Shadow
    private BlockPos field_241138_cr_;
    @Shadow
    private boolean field_241139_cs_;
    @Shadow
    @Final
    public MinecraftServer field_71133_b;
    @Shadow
    public ServerPlayNetHandler field_71135_a;
    @Shadow
    public boolean field_71136_j;
    @Unique
    private boolean origins_isEndRespawning;

    @Shadow
    public abstract void func_146105_b(ITextComponent var1, boolean var2);

    public ServerPlayerEntityMixin(World world, BlockPos pos, float yaw, GameProfile profile) {
        super(world, pos, yaw, profile);
    }

    @Inject(method={"trySleep"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;setSpawnPoint(Lnet/minecraft/util/registry/RegistryKey;Lnet/minecraft/util/math/BlockPos;FZZ)V")}, cancellable=true)
    public void preventAvianSleep(BlockPos pos, CallbackInfoReturnable<Either<PlayerEntity.SleepResult, Unit>> info) {
        OriginComponent.getPowers((Entity)this, PreventSleepPower.class).forEach(p -> {
            if (p.doesPrevent((IWorldReader)this.field_70170_p, pos)) {
                if (p.doesAllowSpawnPoint()) {
                    ((ServerPlayerEntity)this).func_242111_a(this.field_70170_p.func_234923_W_(), pos, this.field_70177_z, false, true);
                }
                info.setReturnValue((Object)Either.left(null));
                this.func_146105_b((ITextComponent)new TranslationTextComponent(p.getMessage()), true);
            }
        });
    }

    private boolean hasObstructedSpawn() {
        ServerWorld world = this.field_71133_b.func_71218_a(this.field_241137_cq_);
        if (this.field_241138_cr_ != null && world != null) {
            return !PlayerEntity.func_242374_a((ServerWorld)world, (BlockPos)this.field_241138_cr_, (float)0.0f, (boolean)this.field_241139_cs_, (boolean)true).isPresent();
        }
        return false;
    }

    @Override
    public void setEndRespawning(boolean endSpawn) {
        this.origins_isEndRespawning = endSpawn;
    }

    @Override
    public boolean isEndRespawning() {
        return this.origins_isEndRespawning;
    }

    @Override
    public boolean hasRealRespawnPoint() {
        return this.field_241138_cr_ != null && !this.hasObstructedSpawn();
    }
}

